#ifndef ZMODELER_STRUCT_H_INCLUDED
#define ZMODELER_STRUCT_H_INCLUDED

#include <afxwin.h>
#include <afxext.h>    //toolbars

#ifdef ZM_STRUCT_EXPORTS
#define DllExport   __declspec(dllexport)
#else
#define DllExport   __declspec(dllimport)
#endif

///////////////////////////////////////////////////
//  Capabilities versions: WORD: max, min:
///////////////////////////////////////////////////
//version 1.06f
#define  ZMODELER_VERSION                     0x0000107A
#define  ZMODELER_LOWEST_CAPABILITY           0x106E0000
#define  ZMODELER_BUILD_VERSION()             ZMODELER_LOWEST_CAPABILITY | ZMODELER_VERSION
#define  ZMODELER_GET_BUILD_VERSION(version)  ((version) & 0xFFFF)
#define  ZMODELER_GET_LOWEST(version)         ((((version) & 0xFFFF0000) >> 16) & 0xFFFF)
#define  ZMODELER_SUPPORTED_VERSION(zm, plug)                               \
      ((ZMODELER_GET_LOWEST(zm) <= ZMODELER_GET_LOWEST(plug)) ||            \
      (ZMODELER_GET_BUILD_VERSION(zm) >= ZMODELER_GET_BUILD_VERSION(plug)))

#define  Z3D_REQUIRE_REGISTERED_ZMODELER  0x10000000

#include <math.h>

#include "Common\defs.h"

#include <3DEngine\3DEngine\3dedefs.h>
#include <3DEngine\3DEngine\tRenderBlock.h>
#include "ZMres.h"

#include "Common\types.h"
#include "Common\flags.h"
#include "Common\Global.h"

// Current state and settings
#include "Common\tState.h"

#include "Struct\tabstrct.h"
#include "Struct\Base.h"
#include "Struct\tVertex.h"
#include "Struct\NormVert.h"

#include "Struct\VertTbl.h"
#include "Struct\VertRef.h"
#include "Struct\tSpline.h"
#include "Struct\tface.h"
#include "Struct\facetbl.h"
#include "Struct\tObject.h"
#include "Struct\objctset.h"

#include "Common\ZFiles.h"
#include "Common\ZMMath.h"
#include "Common\ZMList.h"
#include "Common\TextTool.h"//text files read/write tools.
#include "Common\CRollUpBar.h"
#include "Common\CCurveEdit.h"

//Unrecognized data
#include "Struct\tUnData.h"
#include "Struct\tUDSet.h"

//Undo Stack
#include "Struct\tUndo.h"

//ProcsList
#include "Struct\tProcLst.h"

//Debug
#include "Common\debug.h"

//Export vadiables
#include "Common\var.h"

DllExport DWORD GetZMVersion();
DllExport DWORD GetZMBuildVersion();
DllExport DWORD GetZMLowestVersion();

#endif//ZMODELER_STRUCT_H_INCLUDED
